<?php
/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, 
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program.  
 * If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: usersbrowsingthread.php v1.1 2009-07-17 02:56:23Z - G33K - $
 */
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("global_start", "usersbrowsingthread_templatelist");
$plugins->add_hook("showthread_start", "usersbrowsingthread_run");

function usersbrowsingthread_info()
{		
    $info = array(
        "name"				=> "هاك متصفحي الموضوع",
        "description"		=> " يقوم باظهار متصفحي الموضوع واظهار العدد الخاص بهم اعلي الموضوع",
        "website"			=> "http://g33k.host-ed.net/",
        "author"			=> "- G33K -",
        "authorsite"		=> "http://community.mybboard.net/user-19236.html",
        "version"			=> "1.1",
		"guid" 				=> "ac842603280fc9d50aee03f9978282bb",
		"compatibility" 	=> "16*"
    );
    
    return $info;
}

function usersbrowsingthread_activate()
{
	global $db, $mybb;
	
	// Insert Template elements
	// Remove first to clean up any template edits left from previous installs
	$db->delete_query("templates", "title='usersbrowsingthread_showthread'");
	$db->delete_query("templates", "title='usersbrowsingthread_showthread_user'");
		
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("showthread", "#".preg_quote('
	{$usersbrowsing}')."#i", '', 0);
	
	// Now add
	$g33k_templates = array(
		'usersbrowsingthread_showthread'		=> "<span class=\"smalltext\">{\$lang->users_browsing_thread}<br />{\$onlinemembers}</span><br />",
		'usersbrowsingthread_showthread_user'	=> "{\$comma}{\$user['profilelink']}{\$invisiblemark}"
			);
	
	foreach($g33k_templates as $template_title => $template_data)
	{
		$insert_templates = array(
			'title' => $db->escape_string($template_title),
			'template' => $db->escape_string($template_data),
			'sid' => "-1",
			'version' => "100",
			'dateline' => TIME_NOW
			);
		$db->insert_query('templates', $insert_templates);
	}
	
	find_replace_templatesets("showthread", "#".preg_quote('{$header}')."#i", '{$header}
	{$usersbrowsing}');

}

function usersbrowsingthread_deactivate()
{
	global $db, $mybb;
	
	// Remove template elements
	$db->delete_query("templates", "title='usersbrowsingthread_showthread'");
	$db->delete_query("templates", "title='usersbrowsingthread_showthread_user'");
		
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("showthread", "#".preg_quote('
	{$usersbrowsing}')."#i", '', 0);

}

function usersbrowsingthread_run()
{
	global $db, $mybb, $templates, $lang, $tid, $usersbrowsing;
	
	$lang->load("usersbrowsingthread");
	
	// Get the users browsing this thread.
	if($mybb->settings['browsingthisforum'] != 0)
	{
		$timecut = TIME_NOW - $mybb->settings['wolcutoff'];
	
		$comma = '';
		$guestcount = 0;
		$membercount = 0;
		$inviscount = 0;
		$totalcount = 0;
		$onlinemembers = '';
		$query = $db->query("
			SELECT s.ip, s.uid, u.username, s.time, u.invisible, u.usergroup, u.usergroup, u.displaygroup
			FROM ".TABLE_PREFIX."sessions s
			LEFT JOIN ".TABLE_PREFIX."users u ON (s.uid=u.uid)
			WHERE s.time > '$timecut' AND location2='$tid' AND nopermission != 1
			ORDER BY u.username ASC, s.time DESC
		");
		while($user = $db->fetch_array($query))
		{
			if($user['uid'] == 0)
			{
				++$guestcount;
			}
			else
			{
				if($doneusers[$user['uid']] < $user['time'] || !$doneusers[$user['uid']])
				{
					$doneusers[$user['uid']] = $user['time'];
					++$membercount;
					if($user['invisible'] == 1)
					{
						$invisiblemark = "*";
						++$inviscount;
					}
					else
					{
						$invisiblemark = '';
					}
					
					if($user['invisible'] != 1 || $mybb->usergroup['canviewwolinvis'] == 1 || $user['uid'] == $mybb->user['uid'])
					{
						$user['username'] = format_name($user['username'], $user['usergroup'], $user['displaygroup']);
						$user['profilelink'] = build_profile_link($user['username'], $user['uid']);
						eval("\$onlinemembers .= \"".$templates->get("usersbrowsingthread_showthread_user", 1, 0)."\";");
						$comma = ", ";
					}
				}
			}
		}
		
		$totalcount = $membercount + $guestcount;
	
		if($totalcount != 1)
		{
			$totalbit = $lang->users_browsing_thread_user_plural;
		}
		else
		{
			$totalbit = $lang->users_browsing_thread_user_singular;
		}
		if($membercount != 1)
		{
			$memberbit = $lang->users_browsing_thread_member_plural;
		}
		else
		{
			$memberbit = $lang->users_browsing_thread_member_singular;
		}
		if($inviscount)
		{
			if($inviscount != 1)
			{
				$invisbit1 = $lang->users_browsing_thread_invis_plural;
			}
			else
			{
				$invisbit1 = $lang->users_browsing_thread_invis_singular;
			}
			$invisbit = $lang->sprintf($lang->users_browsing_thread_invis, my_number_format($inviscount), $invisbit1);
		}
		else
		{
			$invisbit = '';
		}
		if($guestcount != 1)
		{
			$guestbit = $lang->users_browsing_thread_guest_plural;
		}
		else
		{
			$guestbit = $lang->users_browsing_thread_guest_singular;
		}
		$lang->users_browsing_thread = $lang->sprintf($lang->users_browsing_thread, my_number_format($totalcount), $totalbit, my_number_format($membercount), $memberbit, $invisbit, my_number_format($guestcount), $guestbit);

		eval("\$usersbrowsing = \"".$templates->get("usersbrowsingthread_showthread")."\";");
	}
}

function usersbrowsingthread_templatelist()
{
	global $templatelist;
	
	if (THIS_SCRIPT == 'showthread.php');
	{
		if (isset($templatelist))
		{
			$templatelist .= ",usersbrowsingthread_showthread_user, usersbrowsingthread_showthread";
		}
		else
		{
			$templatelist = "usersbrowsingthread_showthread_user, usersbrowsingthread_showthread";
		}
	}
}
?>